/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public class DrawSelectionEvent
extends Event {
    private final LevelRenderer levelRenderer;
    private final Camera camera;
    private final HitResult target;
    private final float partialTicks;
    private final PoseStack poseStack;
    private final MultiBufferSource multiBufferSource;

    public DrawSelectionEvent(LevelRenderer levelRenderer, Camera camera, HitResult target, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource) {
        this.levelRenderer = levelRenderer;
        this.camera = camera;
        this.target = target;
        this.partialTicks = partialTicks;
        this.poseStack = poseStack;
        this.multiBufferSource = multiBufferSource;
    }

    public LevelRenderer getLevelRenderer() {
        return this.levelRenderer;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public HitResult getTarget() {
        return this.target;
    }

    public float getPartialTicks() {
        return this.partialTicks;
    }

    public PoseStack getPoseStack() {
        return this.poseStack;
    }

    public MultiBufferSource getMultiBufferSource() {
        return this.multiBufferSource;
    }

    @Cancelable
    public static class HighlightEntity
    extends DrawSelectionEvent {
        public HighlightEntity(LevelRenderer levelRenderer, Camera camera, HitResult target, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource) {
            super(levelRenderer, camera, target, partialTick, poseStack, bufferSource);
        }

        public EntityHitResult getTarget() {
            return (EntityHitResult)this.target;
        }
    }

    @Cancelable
    public static class HighlightBlock
    extends DrawSelectionEvent {
        public HighlightBlock(LevelRenderer levelRenderer, Camera camera, HitResult target, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource) {
            super(levelRenderer, camera, target, partialTick, poseStack, bufferSource);
        }

        public BlockHitResult getTarget() {
            return (BlockHitResult)this.target;
        }
    }
}

